﻿unit tb.Open62541.StatusCodes;


interface

uses
  System.Generics.Collections;

{$MINENUMSIZE 4}

{$IFDEF WIN64}
{$ALIGN 8}
{$ELSE}
{$MESSAGE FATAL '32-Bit wird nicht unterstützt. Bitte als Win64 kompilieren.'}
{$ENDIF}

{$POINTERMATH ON}
{$H+}


const
  UA_STATUSCODE_INFOTYPE_DATAVALUE = $00000400;
  UA_STATUSCODE_INFOBITS_OVERFLOW = $00000080;
  UA_STATUSCODE_GOOD = $00000000;
  UA_STATUSCODE_UNCERTAIN = $40000000;
  UA_STATUSCODE_BAD = $80000000;
  UA_STATUSCODE_BADUNEXPECTEDERROR = $80010000;
  UA_STATUSCODE_BADINTERNALERROR = $80020000;
  UA_STATUSCODE_BADOUTOFMEMORY = $80030000;
  UA_STATUSCODE_BADRESOURCEUNAVAILABLE = $80040000;
  UA_STATUSCODE_BADCOMMUNICATIONERROR = $80050000;
  UA_STATUSCODE_BADENCODINGERROR = $80060000;
  UA_STATUSCODE_BADDECODINGERROR = $80070000;
  UA_STATUSCODE_BADENCODINGLIMITSEXCEEDED = $80080000;
  UA_STATUSCODE_BADREQUESTTOOLARGE = $80B80000;
  UA_STATUSCODE_BADRESPONSETOOLARGE = $80B90000;
  UA_STATUSCODE_BADUNKNOWNRESPONSE = $80090000;
  UA_STATUSCODE_BADTIMEOUT = $800A0000;
  UA_STATUSCODE_BADSERVICEUNSUPPORTED = $800B0000;
  UA_STATUSCODE_BADSHUTDOWN = $800C0000;
  UA_STATUSCODE_BADSERVERNOTCONNECTED = $800D0000;
  UA_STATUSCODE_BADSERVERHALTED = $800E0000;
  UA_STATUSCODE_BADNOTHINGTODO = $800F0000;
  UA_STATUSCODE_BADTOOMANYOPERATIONS = $80100000;
  UA_STATUSCODE_BADTOOMANYMONITOREDITEMS = $80DB0000;
  UA_STATUSCODE_BADDATATYPEIDUNKNOWN = $80110000;
  UA_STATUSCODE_BADCERTIFICATEINVALID = $80120000;
  UA_STATUSCODE_BADSECURITYCHECKSFAILED = $80130000;
  UA_STATUSCODE_BADCERTIFICATEPOLICYCHECKFAILED = $81140000;
  UA_STATUSCODE_BADCERTIFICATETIMEINVALID = $80140000;
  UA_STATUSCODE_BADCERTIFICATEISSUERTIMEINVALID = $80150000;
  UA_STATUSCODE_BADCERTIFICATEHOSTNAMEINVALID = $80160000;
  UA_STATUSCODE_BADCERTIFICATEURIINVALID = $80170000;
  UA_STATUSCODE_BADCERTIFICATEUSENOTALLOWED = $80180000;
  UA_STATUSCODE_BADCERTIFICATEISSUERUSENOTALLOWED = $80190000;
  UA_STATUSCODE_BADCERTIFICATEUNTRUSTED = $801A0000;
  UA_STATUSCODE_BADCERTIFICATEREVOCATIONUNKNOWN = $801B0000;
  UA_STATUSCODE_BADCERTIFICATEISSUERREVOCATIONUNKNOWN = $801C0000;
  UA_STATUSCODE_BADCERTIFICATEREVOKED = $801D0000;
  UA_STATUSCODE_BADCERTIFICATEISSUERREVOKED = $801E0000;
  UA_STATUSCODE_BADCERTIFICATECHAININCOMPLETE = $810D0000;
  UA_STATUSCODE_BADUSERACCESSDENIED = $801F0000;
  UA_STATUSCODE_BADIDENTITYTOKENINVALID = $80200000;
  UA_STATUSCODE_BADIDENTITYTOKENREJECTED = $80210000;
  UA_STATUSCODE_BADSECURECHANNELIDINVALID = $80220000;
  UA_STATUSCODE_BADINVALIDTIMESTAMP = $80230000;
  UA_STATUSCODE_BADNONCEINVALID = $80240000;
  UA_STATUSCODE_BADSESSIONIDINVALID = $80250000;
  UA_STATUSCODE_BADSESSIONCLOSED = $80260000;
  UA_STATUSCODE_BADSESSIONNOTACTIVATED = $80270000;
  UA_STATUSCODE_BADSUBSCRIPTIONIDINVALID = $80280000;
  UA_STATUSCODE_BADREQUESTHEADERINVALID = $802A0000;
  UA_STATUSCODE_BADTIMESTAMPSTORETURNINVALID = $802B0000;
  UA_STATUSCODE_BADREQUESTCANCELLEDBYCLIENT = $802C0000;
  UA_STATUSCODE_BADTOOMANYARGUMENTS = $80E50000;
  UA_STATUSCODE_BADLICENSEEXPIRED = $810E0000;
  UA_STATUSCODE_BADLICENSELIMITSEXCEEDED = $810F0000;
  UA_STATUSCODE_BADLICENSENOTAVAILABLE = $81100000;
  UA_STATUSCODE_GOODSUBSCRIPTIONTRANSFERRED = $002D0000;
  UA_STATUSCODE_GOODCOMPLETESASYNCHRONOUSLY = $002E0000;
  UA_STATUSCODE_GOODOVERLOAD = $002F0000;
  UA_STATUSCODE_GOODCLAMPED = $00300000;
  UA_STATUSCODE_BADNOCOMMUNICATION = $80310000;
  UA_STATUSCODE_BADWAITINGFORINITIALDATA = $80320000;
  UA_STATUSCODE_BADNODEIDINVALID = $80330000;
  UA_STATUSCODE_BADNODEIDUNKNOWN = $80340000;
  UA_STATUSCODE_BADATTRIBUTEIDINVALID = $80350000;
  UA_STATUSCODE_BADINDEXRANGEINVALID = $80360000;
  UA_STATUSCODE_BADINDEXRANGENODATA = $80370000;
  UA_STATUSCODE_BADDATAENCODINGINVALID = $80380000;
  UA_STATUSCODE_BADDATAENCODINGUNSUPPORTED = $80390000;
  UA_STATUSCODE_BADNOTREADABLE = $803A0000;
  UA_STATUSCODE_BADNOTWRITABLE = $803B0000;
  UA_STATUSCODE_BADOUTOFRANGE = $803C0000;
  UA_STATUSCODE_BADNOTSUPPORTED = $803D0000;
  UA_STATUSCODE_BADNOTFOUND = $803E0000;
  UA_STATUSCODE_BADOBJECTDELETED = $803F0000;
  UA_STATUSCODE_BADNOTIMPLEMENTED = $80400000;
  UA_STATUSCODE_BADMONITORINGMODEINVALID = $80410000;
  UA_STATUSCODE_BADMONITOREDITEMIDINVALID = $80420000;
  UA_STATUSCODE_BADMONITOREDITEMFILTERINVALID = $80430000;
  UA_STATUSCODE_BADMONITOREDITEMFILTERUNSUPPORTED = $80440000;
  UA_STATUSCODE_BADFILTERNOTALLOWED = $80450000;
  UA_STATUSCODE_BADSTRUCTUREMISSING = $80460000;
  UA_STATUSCODE_BADEVENTFILTERINVALID = $80470000;
  UA_STATUSCODE_BADCONTENTFILTERINVALID = $80480000;
  UA_STATUSCODE_BADFILTEROPERATORINVALID = $80C10000;
  UA_STATUSCODE_BADFILTEROPERATORUNSUPPORTED = $80C20000;
  UA_STATUSCODE_BADFILTEROPERANDCOUNTMISMATCH = $80C30000;
  UA_STATUSCODE_BADFILTEROPERANDINVALID = $80490000;
  UA_STATUSCODE_BADFILTERELEMENTINVALID = $80C40000;
  UA_STATUSCODE_BADFILTERLITERALINVALID = $80C50000;
  UA_STATUSCODE_BADCONTINUATIONPOINTINVALID = $804A0000;
  UA_STATUSCODE_BADNOCONTINUATIONPOINTS = $804B0000;
  UA_STATUSCODE_BADREFERENCETYPEIDINVALID = $804C0000;
  UA_STATUSCODE_BADBROWSEDIRECTIONINVALID = $804D0000;
  UA_STATUSCODE_BADNODENOTINVIEW = $804E0000;
  UA_STATUSCODE_BADNUMERICOVERFLOW = $81120000;
  UA_STATUSCODE_BADSERVERURIINVALID = $804F0000;
  UA_STATUSCODE_BADSERVERNAMEMISSING = $80500000;
  UA_STATUSCODE_BADDISCOVERYURLMISSING = $80510000;
  UA_STATUSCODE_BADSEMPAHOREFILEMISSING = $80520000;
  UA_STATUSCODE_BADREQUESTTYPEINVALID = $80530000;
  UA_STATUSCODE_BADSECURITYMODEREJECTED = $80540000;
  UA_STATUSCODE_BADSECURITYPOLICYREJECTED = $80550000;
  UA_STATUSCODE_BADTOOMANYSESSIONS = $80560000;
  UA_STATUSCODE_BADUSERSIGNATUREINVALID = $80570000;
  UA_STATUSCODE_BADAPPLICATIONSIGNATUREINVALID = $80580000;
  UA_STATUSCODE_BADNOVALIDCERTIFICATES = $80590000;
  UA_STATUSCODE_BADIDENTITYCHANGENOTSUPPORTED = $80C60000;
  UA_STATUSCODE_BADREQUESTCANCELLEDBYREQUEST = $805A0000;
  UA_STATUSCODE_BADPARENTNODEIDINVALID = $805B0000;
  UA_STATUSCODE_BADREFERENCENOTALLOWED = $805C0000;
  UA_STATUSCODE_BADNODEIDREJECTED = $805D0000;
  UA_STATUSCODE_BADNODEIDEXISTS = $805E0000;
  UA_STATUSCODE_BADNODECLASSINVALID = $805F0000;
  UA_STATUSCODE_BADBROWSENAMEINVALID = $80600000;
  UA_STATUSCODE_BADBROWSENAMEDUPLICATED = $80610000;
  UA_STATUSCODE_BADNODEATTRIBUTESINVALID = $80620000;
  UA_STATUSCODE_BADTYPEDEFINITIONINVALID = $80630000;
  UA_STATUSCODE_BADSOURCENODEIDINVALID = $80640000;
  UA_STATUSCODE_BADTARGETNODEIDINVALID = $80650000;
  UA_STATUSCODE_BADDUPLICATEREFERENCENOTALLOWED = $80660000;
  UA_STATUSCODE_BADINVALIDSELFREFERENCE = $80670000;
  UA_STATUSCODE_BADREFERENCELOCALONLY = $80680000;
  UA_STATUSCODE_BADNODELETERIGHTS = $80690000;
  UA_STATUSCODE_UNCERTAINREFERENCENOTDELETED = $40BC0000;
  UA_STATUSCODE_BADSERVERINDEXINVALID = $806A0000;
  UA_STATUSCODE_BADVIEWIDUNKNOWN = $806B0000;
  UA_STATUSCODE_BADVIEWTIMESTAMPINVALID = $80C90000;
  UA_STATUSCODE_BADVIEWPARAMETERMISMATCH = $80CA0000;
  UA_STATUSCODE_BADVIEWVERSIONINVALID = $80CB0000;
  UA_STATUSCODE_UNCERTAINNOTALLNODESAVAILABLE = $40C00000;
  UA_STATUSCODE_GOODRESULTSMAYBEINCOMPLETE = $00BA0000;
  UA_STATUSCODE_BADNOTTYPEDEFINITION = $80C80000;
  UA_STATUSCODE_UNCERTAINREFERENCEOUTOFSERVER = $406C0000;
  UA_STATUSCODE_BADTOOMANYMATCHES = $806D0000;
  UA_STATUSCODE_BADQUERYTOOCOMPLEX = $806E0000;
  UA_STATUSCODE_BADNOMATCH = $806F0000;
  UA_STATUSCODE_BADMAXAGEINVALID = $80700000;
  UA_STATUSCODE_BADSECURITYMODEINSUFFICIENT = $80E60000;
  UA_STATUSCODE_BADHISTORYOPERATIONINVALID = $80710000;
  UA_STATUSCODE_BADHISTORYOPERATIONUNSUPPORTED = $80720000;
  UA_STATUSCODE_BADINVALIDTIMESTAMPARGUMENT = $80BD0000;
  UA_STATUSCODE_BADWRITENOTSUPPORTED = $80730000;
  UA_STATUSCODE_BADTYPEMISMATCH = $80740000;
  UA_STATUSCODE_BADMETHODINVALID = $80750000;
  UA_STATUSCODE_BADARGUMENTSMISSING = $80760000;
  UA_STATUSCODE_BADNOTEXECUTABLE = $81110000;
  UA_STATUSCODE_BADTOOMANYSUBSCRIPTIONS = $80770000;
  UA_STATUSCODE_BADTOOMANYPUBLISHREQUESTS = $80780000;
  UA_STATUSCODE_BADNOSUBSCRIPTION = $80790000;
  UA_STATUSCODE_BADSEQUENCENUMBERUNKNOWN = $807A0000;
  UA_STATUSCODE_GOODRETRANSMISSIONQUEUENOTSUPPORTED = $00DF0000;
  UA_STATUSCODE_BADMESSAGENOTAVAILABLE = $807B0000;
  UA_STATUSCODE_BADINSUFFICIENTCLIENTPROFILE = $807C0000;
  UA_STATUSCODE_BADSTATENOTACTIVE = $80BF0000;
  UA_STATUSCODE_BADALREADYEXISTS = $81150000;
  UA_STATUSCODE_BADTCPSERVERTOOBUSY = $807D0000;
  UA_STATUSCODE_BADTCPMESSAGETYPEINVALID = $807E0000;
  UA_STATUSCODE_BADTCPSECURECHANNELUNKNOWN = $807F0000;
  UA_STATUSCODE_BADTCPMESSAGETOOLARGE = $80800000;
  UA_STATUSCODE_BADTCPNOTENOUGHRESOURCES = $80810000;
  UA_STATUSCODE_BADTCPINTERNALERROR = $80820000;
  UA_STATUSCODE_BADTCPENDPOINTURLINVALID = $80830000;
  UA_STATUSCODE_BADREQUESTINTERRUPTED = $80840000;
  UA_STATUSCODE_BADREQUESTTIMEOUT = $80850000;
  UA_STATUSCODE_BADSECURECHANNELCLOSED = $80860000;
  UA_STATUSCODE_BADSECURECHANNELTOKENUNKNOWN = $80870000;
  UA_STATUSCODE_BADSEQUENCENUMBERINVALID = $80880000;
  UA_STATUSCODE_BADPROTOCOLVERSIONUNSUPPORTED = $80BE0000;
  UA_STATUSCODE_BADCONFIGURATIONERROR = $80890000;
  UA_STATUSCODE_BADNOTCONNECTED = $808A0000;
  UA_STATUSCODE_BADDEVICEFAILURE = $808B0000;
  UA_STATUSCODE_BADSENSORFAILURE = $808C0000;
  UA_STATUSCODE_BADOUTOFSERVICE = $808D0000;
  UA_STATUSCODE_BADDEADBANDFILTERINVALID = $808E0000;
  UA_STATUSCODE_UNCERTAINNOCOMMUNICATIONLASTUSABLEVALUE = $408F0000;
  UA_STATUSCODE_UNCERTAINLASTUSABLEVALUE = $40900000;
  UA_STATUSCODE_UNCERTAINSUBSTITUTEVALUE = $40910000;
  UA_STATUSCODE_UNCERTAININITIALVALUE = $40920000;
  UA_STATUSCODE_UNCERTAINSENSORNOTACCURATE = $40930000;
  UA_STATUSCODE_UNCERTAINENGINEERINGUNITSEXCEEDED = $40940000;
  UA_STATUSCODE_UNCERTAINSUBNORMAL = $40950000;
  UA_STATUSCODE_GOODLOCALOVERRIDE = $00960000;
  UA_STATUSCODE_BADREFRESHINPROGRESS = $80970000;
  UA_STATUSCODE_BADCONDITIONALREADYDISABLED = $80980000;
  UA_STATUSCODE_BADCONDITIONALREADYENABLED = $80CC0000;
  UA_STATUSCODE_BADCONDITIONDISABLED = $80990000;
  UA_STATUSCODE_BADEVENTIDUNKNOWN = $809A0000;
  UA_STATUSCODE_BADEVENTNOTACKNOWLEDGEABLE = $80BB0000;
  UA_STATUSCODE_BADDIALOGNOTACTIVE = $80CD0000;
  UA_STATUSCODE_BADDIALOGRESPONSEINVALID = $80CE0000;
  UA_STATUSCODE_BADCONDITIONBRANCHALREADYACKED = $80CF0000;
  UA_STATUSCODE_BADCONDITIONBRANCHALREADYCONFIRMED = $80D00000;
  UA_STATUSCODE_BADCONDITIONALREADYSHELVED = $80D10000;
  UA_STATUSCODE_BADCONDITIONNOTSHELVED = $80D20000;
  UA_STATUSCODE_BADSHELVINGTIMEOUTOFRANGE = $80D30000;
  UA_STATUSCODE_BADNODATA = $809B0000;
  UA_STATUSCODE_BADBOUNDNOTFOUND = $80D70000;
  UA_STATUSCODE_BADBOUNDNOTSUPPORTED = $80D80000;
  UA_STATUSCODE_BADDATALOST = $809D0000;
  UA_STATUSCODE_BADDATAUNAVAILABLE = $809E0000;
  UA_STATUSCODE_BADENTRYEXISTS = $809F0000;
  UA_STATUSCODE_BADNOENTRYEXISTS = $80A00000;
  UA_STATUSCODE_BADTIMESTAMPNOTSUPPORTED = $80A10000;
  UA_STATUSCODE_GOODENTRYINSERTED = $00A20000;
  UA_STATUSCODE_GOODENTRYREPLACED = $00A30000;
  UA_STATUSCODE_UNCERTAINDATASUBNORMAL = $40A40000;
  UA_STATUSCODE_GOODNODATA = $00A50000;
  UA_STATUSCODE_GOODMOREDATA = $00A60000;
  UA_STATUSCODE_BADAGGREGATELISTMISMATCH = $80D40000;
  UA_STATUSCODE_BADAGGREGATENOTSUPPORTED = $80D50000;
  UA_STATUSCODE_BADAGGREGATEINVALIDINPUTS = $80D60000;
  UA_STATUSCODE_BADAGGREGATECONFIGURATIONREJECTED = $80DA0000;
  UA_STATUSCODE_GOODDATAIGNORED = $00D90000;
  UA_STATUSCODE_BADREQUESTNOTALLOWED = $80E40000;
  UA_STATUSCODE_BADREQUESTNOTCOMPLETE = $81130000;
  UA_STATUSCODE_BADTRANSACTIONPENDING = $80E80000;
  UA_STATUSCODE_BADTICKETREQUIRED = $811F0000;
  UA_STATUSCODE_BADTICKETINVALID = $81200000;
  UA_STATUSCODE_BADLOCKED = $80E90000;
  UA_STATUSCODE_GOODEDITED = $00DC0000;
  UA_STATUSCODE_GOODPOSTACTIONFAILED = $00DD0000;
  UA_STATUSCODE_UNCERTAINDOMINANTVALUECHANGED = $40DE0000;
  UA_STATUSCODE_GOODDEPENDENTVALUECHANGED = $00E00000;
  UA_STATUSCODE_BADDOMINANTVALUECHANGED = $80E10000;
  UA_STATUSCODE_UNCERTAINDEPENDENTVALUECHANGED = $40E20000;
  UA_STATUSCODE_BADDEPENDENTVALUECHANGED = $80E30000;
  UA_STATUSCODE_GOODEDITED_DEPENDENTVALUECHANGED = $01160000;
  UA_STATUSCODE_GOODEDITED_DOMINANTVALUECHANGED = $01170000;
  UA_STATUSCODE_GOODEDITED_DOMINANTVALUECHANGED_DEPENDENTVALUECHANGED = $01180000;
  UA_STATUSCODE_BADEDITED_OUTOFRANGE = $81190000;
  UA_STATUSCODE_BADINITIALVALUE_OUTOFRANGE = $811A0000;
  UA_STATUSCODE_BADOUTOFRANGE_DOMINANTVALUECHANGED = $811B0000;
  UA_STATUSCODE_BADEDITED_OUTOFRANGE_DOMINANTVALUECHANGED = $811C0000;
  UA_STATUSCODE_BADOUTOFRANGE_DOMINANTVALUECHANGED_DEPENDENTVALUECHANGED = $811D0000;
  UA_STATUSCODE_BADEDITED_OUTOFRANGE_DOMINANTVALUECHANGED_DEPENDENTVALUECHANGED = $811E0000;
  UA_STATUSCODE_GOODCOMMUNICATIONEVENT = $00A70000;
  UA_STATUSCODE_GOODSHUTDOWNEVENT = $00A80000;
  UA_STATUSCODE_GOODCALLAGAIN = $00A90000;
  UA_STATUSCODE_GOODNONCRITICALTIMEOUT = $00AA0000;
  UA_STATUSCODE_BADINVALIDARGUMENT = $80AB0000;
  UA_STATUSCODE_BADCONNECTIONREJECTED = $80AC0000;
  UA_STATUSCODE_BADDISCONNECT = $80AD0000;
  UA_STATUSCODE_BADCONNECTIONCLOSED = $80AE0000;
  UA_STATUSCODE_BADINVALIDSTATE = $80AF0000;
  UA_STATUSCODE_BADENDOFSTREAM = $80B00000;
  UA_STATUSCODE_BADNODATAAVAILABLE = $80B10000;
  UA_STATUSCODE_BADWAITINGFORRESPONSE = $80B20000;
  UA_STATUSCODE_BADOPERATIONABANDONED = $80B30000;
  UA_STATUSCODE_BADEXPECTEDSTREAMTOBLOCK = $80B40000;
  UA_STATUSCODE_BADWOULDBLOCK = $80B50000;
  UA_STATUSCODE_BADSYNTAXERROR = $80B60000;
  UA_STATUSCODE_BADMAXCONNECTIONSREACHED = $80B70000;
  UA_STATUSCODE_UNCERTAINTRANSDUCERINMANUAL = $42080000;
  UA_STATUSCODE_UNCERTAINSIMULATEDVALUE = $42090000;
  UA_STATUSCODE_UNCERTAINSENSORCALIBRATION = $420A0000;
  UA_STATUSCODE_UNCERTAINCONFIGURATIONERROR = $420F0000;
  UA_STATUSCODE_GOODCASCADEINITIALIZATIONACKNOWLEDGED = $04010000;
  UA_STATUSCODE_GOODCASCADEINITIALIZATIONREQUEST = $04020000;
  UA_STATUSCODE_GOODCASCADENOTINVITED = $04030000;
  UA_STATUSCODE_GOODCASCADENOTSELECTED = $04040000;
  UA_STATUSCODE_GOODFAULTSTATEACTIVE = $04070000;
  UA_STATUSCODE_GOODINITIATEFAULTSTATE = $04080000;
  UA_STATUSCODE_GOODCASCADE = $04090000;
  UA_STATUSCODE_BADDATASETIDINVALID = $80E70000;

implementation
 var
  StatusCodeList: TDictionary<string, string>;
initialization
  StatusCodeList := TDictionary<string, string>.Create;
  StatusCodeList.add('$00000000', 'Good');
  StatusCodeList.add('$00000400', 'Info: DataValue');
  StatusCodeList.add('$00000080', 'Info: Overflow');
  StatusCodeList.add('$80010000', 'Unerwarteter Fehler');
  StatusCodeList.add('$80020000', 'Interner Fehler');
  StatusCodeList.add('$80030000', 'Nicht genug Speicher');
  StatusCodeList.add('$80040000', 'Ressource nicht verfügbar');
  StatusCodeList.add('$80050000', 'Kommunikationsfehler');
  StatusCodeList.add('$80060000', 'Kodierungsfehler');
  StatusCodeList.add('$80070000', 'Dekodierungsfehler');
  StatusCodeList.add('$80080000', 'Kodierungs-/Dekodierungslimits überschritten');
  StatusCodeList.add('$80B80000', 'Anfrage zu groß');
  StatusCodeList.add('$80B90000', 'Antwort zu groß');
  StatusCodeList.add('$80090000', 'Unbekannte Antwort');
  StatusCodeList.add('$800A0000', 'Timeout');
  StatusCodeList.add('$800B0000', 'Dienst nicht unterstützt');
  StatusCodeList.add('$800C0000', 'Herunterfahren - Operation abgebrochen');
  StatusCodeList.add('$800D0000', 'Server nicht verbunden');
  StatusCodeList.add('$800E0000', 'Server angehalten');
  StatusCodeList.add('$800F0000', 'Nichts zu tun');
  StatusCodeList.add('$80100000', 'Zu viele Operationen');
  StatusCodeList.add('$80DB0000', 'Zu viele MonitoredItems');
  StatusCodeList.add('$80110000', 'Unbekannte Datentyp-ID');
  StatusCodeList.add('$80120000', 'Zertifikat ungültig');
  StatusCodeList.add('$80130000', 'Sicherheitsprüfung fehlgeschlagen');
  StatusCodeList.add('$81140000', 'Zertifikat entspricht nicht der Sicherheitsrichtlinie');
  StatusCodeList.add('$80140000', 'Zertifikat abgelaufen oder noch nicht gültig');
  StatusCodeList.add('$80150000', 'Ausstellerzertifikat abgelaufen oder noch nicht gültig');
  StatusCodeList.add('$80160000', 'Hostname stimmt nicht mit Zertifikat überein');
  StatusCodeList.add('$80170000', 'URI stimmt nicht mit Zertifikat überein');
  StatusCodeList.add('$80180000', 'Zertifikat darf nicht verwendet werden');
  StatusCodeList.add('$80190000', 'Ausstellerzertifikat darf nicht verwendet werden');
  StatusCodeList.add('$801A0000', 'Zertifikat nicht vertrauenswürdig');
  StatusCodeList.add('$801B0000', 'Zertifikatswiderruf unbekannt');
  StatusCodeList.add('$801C0000', 'Ausstellerwiderruf unbekannt');
  StatusCodeList.add('$801D0000', 'Zertifikat widerrufen');
  StatusCodeList.add('$801E0000', 'Ausstellerzertifikat widerrufen');
  StatusCodeList.add('$810D0000', 'Zertifikatskette unvollständig');
  StatusCodeList.add('$801F0000', 'Benutzerzugriff verweigert');
  StatusCodeList.add('$80200000', 'Identitätstoken ungültig');
  StatusCodeList.add('$80210000', 'Identitätstoken abgelehnt');
  StatusCodeList.add('$80220000', 'SecureChannel ungültig');
  StatusCodeList.add('$80230000', 'Zeitstempel ungültig');
  StatusCodeList.add('$80240000', 'Nonce ungültig');
  StatusCodeList.add('$80250000', 'Session-ID ungültig');
  StatusCodeList.add('$80260000', 'Session geschlossen');
  StatusCodeList.add('$80270000', 'Session nicht aktiviert');
  StatusCodeList.add('$80280000', 'Subscription-ID ungültig');
  StatusCodeList.add('$802A0000', 'Request-Header ungültig');
  StatusCodeList.add('$802B0000', 'TimestampsToReturn ungültig');
  StatusCodeList.add('$802C0000', 'Anfrage vom Client abgebrochen');
  StatusCodeList.add('$80E50000', 'Zu viele Argumente');
  StatusCodeList.add('$810E0000', 'Lizenz abgelaufen');
  StatusCodeList.add('$810F0000', 'Lizenzgrenzen überschritten');
  StatusCodeList.add('$81100000', 'Lizenz nicht verfügbar');
  StatusCodeList.add('$002D0000', 'Subscription übertragen');
  StatusCodeList.add('$002E0000', 'Wird asynchron abgeschlossen');
  StatusCodeList.add('$002F0000', 'Überlastung');
  StatusCodeList.add('$00300000', 'Wert begrenzt (clamped)');
  StatusCodeList.add('$80310000', 'Keine Kommunikation');
  StatusCodeList.add('$80320000', 'Warten auf Initialdaten');
  StatusCodeList.add('$80330000', 'NodeId ungültig');
  StatusCodeList.add('$80340000', 'NodeId unbekannt');
  StatusCodeList.add('$80350000', 'Attribut ungültig');
  StatusCodeList.add('$80360000', 'IndexRange ungültig');
  StatusCodeList.add('$80370000', 'Keine Daten im Indexbereich');
  StatusCodeList.add('$80380000', 'Datenencoding ungültig');
  StatusCodeList.add('$80390000', 'Datenencoding nicht unterstützt');
  StatusCodeList.add('$803A0000', 'Nicht lesbar');
  StatusCodeList.add('$803B0000', 'Nicht schreibbar');
  StatusCodeList.add('$803C0000', 'Wert außerhalb des Bereichs');
  StatusCodeList.add('$803D0000', 'Operation nicht unterstützt');
  StatusCodeList.add('$803E0000', 'Nicht gefunden');
  StatusCodeList.add('$803F0000', 'Objekt gelöscht');
  StatusCodeList.add('$80400000', 'Nicht implementiert');
  StatusCodeList.add('$80410000', 'MonitoringMode ungültig');
  StatusCodeList.add('$80420000', 'MonitoredItem-ID ungültig');
  StatusCodeList.add('$80430000', 'MonitoredItem-Filter ungültig');
  StatusCodeList.add('$80440000', 'MonitoredItem-Filter nicht unterstützt');
  StatusCodeList.add('$80450000', 'Filter nicht erlaubt');
  StatusCodeList.add('$80460000', 'Strukturparameter fehlt');
  StatusCodeList.add('$80470000', 'EventFilter ungültig');
  StatusCodeList.add('$80480000', 'ContentFilter ungültig');
  StatusCodeList.add('$80C10000', 'Filteroperator ungültig');
  StatusCodeList.add('$80C20000', 'Filteroperator nicht unterstützt');
  StatusCodeList.add('$80C30000', 'Operandanzahl stimmt nicht');
  StatusCodeList.add('$80490000', 'Filteroperand ungültig');
  StatusCodeList.add('$80C40000', 'Filterelement ungültig');
  StatusCodeList.add('$80C50000', 'Literal ungültig');
  StatusCodeList.add('$804A0000', 'ContinuationPoint ungültig');
  StatusCodeList.add('$804B0000', 'Keine ContinuationPoints verfügbar');
  StatusCodeList.add('$804C0000', 'ReferenceTypeId ungültig');
  StatusCodeList.add('$804D0000', 'BrowseDirection ungültig');
  StatusCodeList.add('$804E0000', 'Node nicht in View');
  StatusCodeList.add('$81120000', 'Numerischer Überlauf');
  StatusCodeList.add('$804F0000', 'ServerUri ungültig');
  StatusCodeList.add('$80500000', 'ServerName fehlt');
  StatusCodeList.add('$80510000', 'DiscoveryUrl fehlt');
  StatusCodeList.add('$80520000', 'Semaphore-Datei ungültig');
  StatusCodeList.add('$80530000', 'RequestType ungültig');
  StatusCodeList.add('$80540000', 'SecurityMode abgelehnt');
  StatusCodeList.add('$80550000', 'SecurityPolicy abgelehnt');
  StatusCodeList.add('$80560000', 'Zu viele Sessions');
  StatusCodeList.add('$80570000', 'Benutzersignatur ungültig');
  StatusCodeList.add('$80580000', 'Anwendungssignatur ungültig');
  StatusCodeList.add('$80590000', 'Kein gültiges Zertifikat');
  StatusCodeList.add('$80C60000', 'Identitätswechsel nicht unterstützt');
  StatusCodeList.add('$805A0000', 'Anfrage durch Cancel-Service abgebrochen');
  StatusCodeList.add('$805B0000', 'ParentNodeId ungültig');
  StatusCodeList.add('$805C0000', 'Referenz nicht erlaubt');
  StatusCodeList.add('$805D0000', 'NodeId abgelehnt');
  StatusCodeList.add('$805E0000', 'NodeId existiert bereits');
  StatusCodeList.add('$805F0000', 'NodeClass ungültig');
  StatusCodeList.add('$80600000', 'BrowseName ungültig');
  StatusCodeList.add('$80610000', 'BrowseName nicht eindeutig');
  StatusCodeList.add('$80620000', 'NodeAttribute ungültig');
  StatusCodeList.add('$80630000', 'TypeDefinition ungültig');
  StatusCodeList.add('$80640000', 'SourceNodeId ungültig');
  StatusCodeList.add('$80650000', 'TargetNodeId ungültig');
  StatusCodeList.add('$80660000', 'Referenz existiert bereits');
  StatusCodeList.add('$80670000', 'Self-Reference ungültig');
  StatusCodeList.add('$80680000', 'Referenz nur lokal erlaubt');
  StatusCodeList.add('$80690000', 'Löschen des Knotens nicht erlaubt');
  StatusCodeList.add('$40BC0000', 'Nicht alle Referenzen gelöscht');
  StatusCodeList.add('$806A0000', 'ServerIndex ungültig');
  StatusCodeList.add('$806B0000', 'ViewId unbekannt');
  StatusCodeList.add('$80C90000', 'View-Zeitstempel ungültig');
  StatusCodeList.add('$80CA0000', 'View-Parameter inkonsistent');
  StatusCodeList.add('$80CB0000', 'View-Version ungültig');
  StatusCodeList.add('$40C00000', 'Nicht alle Knoten verfügbar');
  StatusCodeList.add('$00BA0000', 'Ergebnis möglicherweise unvollständig');
  StatusCodeList.add('$80C80000', 'Keine TypeDefinition');
  StatusCodeList.add('$406C0000', 'Referenz zeigt auf anderen Server');
  StatusCodeList.add('$806D0000', 'Zu viele Treffer');
  StatusCodeList.add('$806E0000', 'Abfrage zu komplex');
  StatusCodeList.add('$806F0000', 'Kein Treffer');
  StatusCodeList.add('$80700000', 'MaxAge ungültig');
  StatusCodeList.add('$80E60000', 'SecurityMode unzureichend');
  StatusCodeList.add('$80710000', 'HistoryDetails ungültig');
  StatusCodeList.add('$80720000', 'History-Operation nicht unterstützt');
  StatusCodeList.add('$80BD0000', 'TimestampToReturn ungültig');
  StatusCodeList.add('$80730000', 'Schreiben nicht unterstützt');
  StatusCodeList.add('$80740000', 'Typ stimmt nicht überein');
  StatusCodeList.add('$80750000', 'MethodId ungültig');
  StatusCodeList.add('$80760000', 'Argumente fehlen');
  StatusCodeList.add('$81110000', 'Nicht ausführbar');
  StatusCodeList.add('$80770000', 'Zu viele Subscriptions');
  StatusCodeList.add('$80780000', 'Zu viele PublishRequests');
  StatusCodeList.add('$80790000', 'Keine Subscription verfügbar');
  StatusCodeList.add('$807A0000', 'Sequenznummer unbekannt');
  StatusCodeList.add('$807B0000', 'Nachricht nicht verfügbar');
  StatusCodeList.add('$807C0000', 'Clientprofil unzureichend');
  StatusCodeList.add('$80BF0000', 'Zustand nicht aktiv');
  StatusCodeList.add('$81150000', 'Regel existiert bereits');
  StatusCodeList.add('$807D0000', 'TCP-Server zu beschäftigt');
  StatusCodeList.add('$807E0000', 'TCP-Nachrichtentyp ungültig');
  StatusCodeList.add('$807F0000', 'TCP-SecureChannel unbekannt');
  StatusCodeList.add('$80800000', 'TCP-Nachricht zu groß');
  StatusCodeList.add('$80810000', 'TCP: Nicht genug Ressourcen');
  StatusCodeList.add('$80820000', 'TCP: Interner Fehler');
  StatusCodeList.add('$80830000', 'TCP-Endpoint-URL ungültig');
  StatusCodeList.add('$80840000', 'Anfrage durch Netzwerkunterbrechung gestört');
  StatusCodeList.add('$80850000', 'Anfrage-Timeout');
  StatusCodeList.add('$80860000', 'SecureChannel geschlossen');
  StatusCodeList.add('$80870000', 'SecureChannel-Token unbekannt/abgelaufen');
  StatusCodeList.add('$80880000', 'Sequenznummer ungültig');
  StatusCodeList.add('$80BE0000', 'Protokollversion nicht unterstützt');
  StatusCodeList.add('$80890000', 'Konfigurationsfehler');
  StatusCodeList.add('$808A0000', 'Nicht verbunden');
  StatusCodeList.add('$808B0000', 'Gerätefehler');
  StatusCodeList.add('$808C0000', 'Sensorfehler');
  StatusCodeList.add('$808D0000', 'Datenquelle außer Betrieb');
  StatusCodeList.add('$808E0000', 'Deadband-Filter ungültig');
  StatusCodeList.add('$408F0000', 'Letzter gültiger Wert - keine Kommunikation');
  StatusCodeList.add('$40900000', 'Wert wird nicht mehr aktualisiert');
  StatusCodeList.add('$40910000', 'Wert manuell überschrieben');
  StatusCodeList.add('$40920000', 'Initialwert');
  StatusCodeList.add('$40930000', 'Sensor ungenau / am Limit');
  StatusCodeList.add('$40940000', 'Engineering-Einheiten überschritten');
  StatusCodeList.add('$40950000', 'Zu wenige gültige Quellen');
  StatusCodeList.add('$00960000', 'Lokale Übersteuerung');
  StatusCodeList.add('$80970000', 'Condition-Refresh fehlgeschlagen');
  StatusCodeList.add('$80980000', 'Condition bereits deaktiviert');
  StatusCodeList.add('$80CC0000', 'Condition bereits aktiviert');
  StatusCodeList.add('$80990000', 'Condition deaktiviert');
  StatusCodeList.add('$809A0000', 'EventId unbekannt');
  StatusCodeList.add('$80BB0000', 'Event nicht bestätigbar');
  StatusCodeList.add('$80CD0000', 'Dialog nicht aktiv');
  StatusCodeList.add('$80CE0000', 'Dialogantwort ungültig');
  StatusCodeList.add('$80CF0000', 'Condition-Branch bereits bestätigt');
  StatusCodeList.add('$80D00000', 'Condition-Branch bereits bestätigt (confirm)');
  StatusCodeList.add('$80D10000', 'Condition bereits shelved');
  StatusCodeList.add('$80D20000', 'Condition nicht shelved');
  StatusCodeList.add('$80D30000', 'Shelving-Zeit außerhalb des gültigen Bereichs');
  StatusCodeList.add('$809B0000', 'Keine Daten');
  StatusCodeList.add('$80D70000', 'Grenzwert nicht gefunden');
  StatusCodeList.add('$80D80000', 'Grenzwert nicht unterstützt');
  StatusCodeList.add('$809D0000', 'Daten verloren');
  StatusCodeList.add('$809E0000', 'Daten nicht verfügbar');
  StatusCodeList.add('$809F0000', 'Eintrag existiert bereits');
  StatusCodeList.add('$80A00000', 'Kein Eintrag vorhanden');
  StatusCodeList.add('$80A10000', 'Zeitstempel nicht unterstützt');
  StatusCodeList.add('$00A20000', 'Eintrag eingefügt');
  StatusCodeList.add('$00A30000', 'Eintrag ersetzt');
  StatusCodeList.add('$40A40000', 'Zu wenige gültige Werte');
  StatusCodeList.add('$00A50000', 'Keine Daten');
  StatusCodeList.add('$00A60000', 'Weitere Daten verfügbar');
  StatusCodeList.add('$80D40000', 'Aggregate-Liste passt nicht');
  StatusCodeList.add('$80D50000', 'Aggregate nicht unterstützt');
  StatusCodeList.add('$80D60000', 'Ungültige Aggregate-Eingaben');
  StatusCodeList.add('$80DA0000', 'Aggregate-Konfiguration ungültig');
  StatusCodeList.add('$00D90000', 'Ungültige Daten ignoriert');
  StatusCodeList.add('$80E40000', 'Anfrage nicht erlaubt');
  StatusCodeList.add('$81130000', 'Anfrage noch nicht verarbeitet');
  StatusCodeList.add('$00DC0000', 'Wert bearbeitet');
  StatusCodeList.add('$00DD0000', 'Post-Actions fehlgeschlagen');
  StatusCodeList.add('$40DE0000', 'EngineeringUnit geändert - Wert basiert noch auf alter Einheit');
  StatusCodeList.add('$00E00000', 'Abhängiger Wert geändert (nicht angewendet)');
  StatusCodeList.add('$80E10000', 'Dominanter Wert geändert - Status Bad');
  StatusCodeList.add('$40E20000', 'Abhängiger Wert geändert - Qualität unsicher');
  StatusCodeList.add('$80E30000', 'Abhängiger Wert geändert - Qualität Bad');
  StatusCodeList.add('$00A70000', 'Kommunikationsereignis');
  StatusCodeList.add('$00A80000', 'System fährt herunter');
  StatusCodeList.add('$00A90000', 'Erneuter Aufruf erforderlich');
  StatusCodeList.add('$00AA0000', 'Nicht-kritischer Timeout');
  StatusCodeList.add('$80AB0000', 'Ungültiges Argument');
  StatusCodeList.add('$80AC0000', 'Verbindung abgelehnt');
  StatusCodeList.add('$80AD0000', 'Server hat getrennt');
  StatusCodeList.add('$80AE0000', 'Verbindung geschlossen');
  StatusCodeList.add('$80AF0000', 'Ungültiger Zustand');
  StatusCodeList.add('$80B00000', 'Ende des Streams');
  StatusCodeList.add('$80B10000', 'Keine Daten verfügbar (non-blocking)');
  StatusCodeList.add('$80B20000', 'Warten auf Antwort');
  StatusCodeList.add('$80B30000', 'Operation abgebrochen');
  StatusCodeList.add('$80B40000', 'Stream hat nicht alle Daten geliefert');
  StatusCodeList.add('$80B50000', 'Operation würde blockieren');
  StatusCodeList.add('$80B60000', 'Syntaxfehler');
  StatusCodeList.add('$80B70000', 'Maximale Anzahl an Verbindungen erreicht');

 finalization
  StatusCodeList.free;

end.